import usePreferences from '../hooks/usePreferences';

export const useNumberFormat = () => {
    const {
        preference: { thousand_separator } = {},
        company: { dflt_currency_symbol } = {},
    } = usePreferences();
    const decimalSeparator = thousand_separator == '.' ? ',' : '.';
    const numberFormat = (value = 0) => {
        let regexCurrencySymbol = new RegExp('\\' + dflt_currency_symbol, 'g');
        let price = String(value)
        ?.replace(regexCurrencySymbol, '')
        .replace(/,/i, decimalSeparator == ',' ? '.' : '');
        return Number(price);
    };
    return numberFormat;
};
